System.Gadget.settingsUI = "settings.html";
System.Gadget.onSettingsClosed = closeSetting;

var timer;
var ipAddr; 
var period;
var macAddr="";
//-------------------------------------------------------------------------------------------

function LoadValues() {	   
  var ip = System.Gadget.Settings.readString("ip");
  var timeout = System.Gadget.Settings.read("timeout");
  var flag = System.Gadget.Settings.read("flag");
  if (flag === "")
    flag = true;
  
  if (!flag)
  {
    ipAddr = (ip != "") ? "http://" + ip : "http://portal.solarmonitor.cz";		
    macAddr = System.Gadget.Settings.readString("mac");
    period = (timeout != "") ? timeout: 300;    
  }
  else
  {  
  	ipAddr = (ip != "") ? "http://" + ip + "/values.xml" : "http://demo1.etech.cz/values.xml";		
    period = (timeout != "") ? timeout: 15;	
  }
  window.setTimeout("getValues();", 1000);
}
//-------------------------------------------------------------------------------------------

//get value by sensor ID from Poseidon device
function getValues() 
{
  barUpdate();

  if (ipAddr != 0) 
  {
    document.getElementById("info").href = ipAddr;

    // branch for native XMLHttpRequest object (Mozilla, Opera)
    if (window.XMLHttpRequest) {
      if (window.netscape)
        netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");

      httpRequest = new XMLHttpRequest();
      if (httpRequest.overrideMimeType)
        httpRequest.overrideMimeType('text/xml');
    }
    //for IE (now run only IE)
    else if (window.ActiveXObject)
      httpRequest = new ActiveXObject("Microsoft.XMLHTTP");
  
    if (httpRequest) 
    {
    	httpRequest.onreadystatechange = processRequest;
    	//unique only for Opera (cache problem)
    	if (macAddr.length > 0)
				httpRequest.open('GET', ipAddr + "/gadget/values.php" + "?unique=" + Math.random() +"&mac=" + macAddr, true);
    	else
				httpRequest.open('GET', ipAddr + "?unique=" + Math.random(), true);

    	httpRequest.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
    	httpRequest.send(null);
    } 
    else 
      errMesg("Chybný požadavek");
  } 
  else
    errMesg("Prázdná URL");
}
//-----------------------------------------------------------------------------------------

function processRequest() 
{
  if (httpRequest.readyState == 4) 
  {
    if (httpRequest.status == 200 || httpRequest.status == 304) 
		{
      if (window.netscape)
        netscape.security.PrivilegeManager.enablePrivilege("UniversalBrowserRead");
      var agent = httpRequest.responseXML.getElementsByTagName('Agent');
      var name = agent.item(0).getElementsByTagName("DeviceName")[0].firstChild.nodeValue;

      var energy = httpRequest.responseXML.getElementsByTagName('Energy');

      var total = energy.item(0).getElementsByTagName("Total")[0].firstChild.nodeValue;
      var today = energy.item(0).getElementsByTagName("Today")[0].firstChild.nodeValue;
    
      var price = httpRequest.responseXML.getElementsByTagName('Prices');
      var rate = price.item(0).getElementsByTagName("Main")[0].firstChild.nodeValue;

      var inverterset = httpRequest.responseXML.getElementsByTagName('InverterSet'); 
      
      var power = 0;
      var online = -1;

			var entry = inverterset.item(0).getElementsByTagName('Entry');
		
      for (var i = 0; i < entry.length; i++)
      {
      	//kvuli starsim sim fw, kde se jeste posilala vsechna inverter entry a v nich <E>
      	if (entry.item(i).getElementsByTagName('E')[0] != null)
				{
	      	if (entry.item(i).getElementsByTagName('E')[0].firstChild.nodeValue == '0')
	      		continue;
	      }

	      if (entry.item(i).getElementsByTagName("Online")[0].firstChild.nodeValue == '0')
	      {
	 				online = 0;
					continue;     	
				}
      		
	    	if (online == -1)
	    		online = 1;

					//stara verze xml
					if (entry.item(i).getElementsByTagName('Power')[0])
			      power += Number(entry.item(i).getElementsByTagName('Power')[0].firstChild.nodeValue);
			    //nova verze xml
			    else
			    {
						var val = entry.item(i).getElementsByTagName('Val');
					
			      for (var j = 0; j < val.length; j++)
			      {
							if (val.item(j).attributes.getNamedItem("n").value == "Pac")
							{
								if (val.item(j).firstChild.nodeValue != "-")
									power += Number(val.item(j).firstChild.nodeValue);
							}
						}
					}
			}

			if (online == -1)
				power = '-';

      document.getElementById("info").innerHTML = name;     
      document.getElementById("value_today").innerHTML = Math.floor((today / 1000)*100)/100 + " kWh";
      document.getElementById("price_today").innerHTML = Math.floor((today*rate)/(10000))/(100) + " Kč";

      document.getElementById("value_total").innerHTML = Math.floor((total / 1000)*100)/100 + " kWh";
      document.getElementById("price_total").innerHTML = Math.floor((total*rate)/(10000))/(100) + " Kč";

      document.getElementById("power").innerHTML = power + " W";
      
      document.getElementById("info").style.color = (online == 1) ? "#0c0" : "YELLOW";

      barStop();
    } 
  }
  
  switch(httpRequest.status)
  {
    case 12002:  //ERROR_INTERNET_TIMEOUT
    case 12007:  //ERROR_INTERNET_NAME_NOT_RESOLVED
     errMesg("Neznámá IP");  
     break;

    case 12029:	 //ERROR_INTERNET_CANNOT_CONNECT
    case 12030:  //ERROR_INTERNET_CONNECTION_ABORTED
    case 12031:  //ERROR_INTERNET_CONNECTION_RESET
      errMesg("Nelze připojit");
      break;

    default:
			barStop();
  }
  
  clearTimeout(timer);
  timer = window.setTimeout("getValues();", period * 1000);
}
//-----------------------------------------------------------------------------------------------

function errMesg(message)
{
  document.getElementById("info").style.color = "RED";
  document.getElementById("info").innerHTML = message;

  document.getElementById("value_today").innerHTML = "- kWh";
  document.getElementById("price_today").innerHTML = "- Kč";
  document.getElementById("value_total").innerHTML = "- kWh";
  document.getElementById("price_total").innerHTML = "- Kč";
  document.getElementById("power").innerHTML = "- W";

  barStop();
}
//-----------------------------------------------------------------------------------------------

function closeSetting(event) 
{
  if (event.closeAction == event.Action.commit) 
  {
    var flag = System.Gadget.Settings.read("flag");
    var ip = System.Gadget.Settings.readString("ip");
    period = System.Gadget.Settings.read("timeout");

    macAddr = "";
    if (!flag)
    {
      ipAddr = "http://" + ip;		
		  macAddr = System.Gadget.Settings.readString("mac");
      period = (period < 300) ? 300 : period;    
    }
    else  
      ipAddr = "http://" + ip + "/values.xml";
    
    clearTimeout(timer);
    barStop();
    getValues();
  }
}
//------------------------------------------------------------------------------------------------


//*************

// Progressbar

//*************

var barCount = 10;
var barActual = barCount;
var barTimer;

function barClear() 
{
  for (var i = 1; i <= barCount; i++) 
    document.getElementById('rec'+i).style.backgroundColor = 'transparent';
  
  barActual = 0;
}
//------------------------------------------------------------------------------------------------

function barUpdate() 
{  
  document.getElementById('bar').style.visibility = 'visible';
  
  barActual++;
  
  if (barActual > barCount) 
    barClear();
  else 
    document.getElementById('rec'+barActual).style.backgroundColor = '#AAA';
  
  barTimer = setTimeout('barUpdate()', 100);
}
//------------------------------------------------------------------------------------------------

function barStop() 
{
  clearTimeout(barTimer);
  barClear();
  document.getElementById('bar').style.visibility = 'hidden';
}
//------------------------------------------------------------------------------------------------
